#include <iostream>
using namespace std;
#define boardSize 8


void initBoard(int board[][boardSize])
{
	for (int i=0;i<boardSize;i++)
		for (int j=0;j<boardSize;j++)
			board[i][j]=0;
}
void markRookields(int board[][boardSize],int a,int b)
{
	for (int i=a-1;i>=0;i--)
	{
		if (board[i][b]>=0)
			board[i][b]++;
		else
			break;
	}

	for (int i=a+1;i<boardSize;i++)
	{
		if (board[i][b]>=0)
			board[i][b]++;
		else
			break;
	}

	for (int i=b-1;i>=0;i--)
	{
		if (board[a][i]>=0)
			board[a][i]++;
		else
			break;
	}

	for (int i=b+1;i<boardSize;i++)
	{
		if (board[a][i]>=0)
			board[a][i]++;
		else
			break;
	}

}

void markBishopFields(int board[][boardSize],int a,int b)
{
	for (int i=a-1,j=b-1;i>=0 && j>=0;i--,j--)
	{
		if (board[i][j]>=0)
			board[i][j]++;
		else
			break;
	}

	for (int i=a-1,j=b+1;i>=0 && j<boardSize;i--,j++)
	{
		if (board[i][j]>=0)
			board[i][j]++;
		else
			break;
	}

	for (int i=a+1,j=b-1;i<boardSize && j>=0;i++,j--)
	{
		if (board[i][j]>=0)
			board[i][j]++;
		else
			break;
	}

	for (int i=a+1,j=b+1;i<boardSize && j<boardSize;i++,j++)
	{
		if (board[i][j]>=0)
			board[i][j]++;
		else
			break;
	}
}

void markField(int board[][boardSize],int a,int b)
{
	if ((a>=0) && (a<boardSize) &&
		(b>=0) && (b<boardSize)	&& board[a][b]>=0)
		board[a][b]++;
}

void markKnightFields(int board[][boardSize],int a,int b)
{
	markField(board,a+1,b-2);
	markField(board,a+1,b+2);
	markField(board,a+2,b-1);
	markField(board,a+2,b+1);
	markField(board,a-1,b-2);
	markField(board,a-1,b+2);
	markField(board,a-2,b-1);
	markField(board,a-2,b+1);
}

void printBoard(int board[][boardSize])
{
	for (int i=0;i<boardSize;i++)
	{
		for (int j=0;j<boardSize;j++)
			printf("%2d",board[i][j]);
		printf("\n");
	}

}

void findAndPrint(int board[][boardSize])
{
	for (int i=0;i<boardSize;i++)
		for (int j=0;j<boardSize;j++)
			if (board[i][j] >= 2)
				cout<<(char)('A'+j)<<(char)('1'+i)<<",";
}

int main121(void)
{
	int board[boardSize][boardSize];
	initBoard(board);
	board[0][2] = -1; //rook
	board[0][3] = -2; //knight
	board[5][2] = -2; //knight
	board[3][3] = -3; //bishop
	
	markRookields(board,0,2);
	markKnightFields(board,0,3);
	markKnightFields(board,5,2);
	markBishopFields(board,3,3);

	printBoard(board);
	findAndPrint(board);
	return 0;
}